/***********************************************************************

                       CSA Library, Free Evaluation Version 2.2.0 
                                           Release: June 9th 1997 

       Set of 'portable' functions, to overcome differences
       between platforms and compilers.
       The names of these functions are always of the format:
	       p<Capital><lowercase string>

       Example: The DOS function 'strupr()', has  now a portable
		counterpart 'pStrupr()'.


                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/


#ifndef __CSPORT_H
#define __CSPORT_H


#include "cstypes.h"

////////////////////////// String releated /////////////////////////////////

/*
   Compares at most the first 'len' bytes of the strings 'p' and 'q'.
   The comparison is done case INsensitive.

   Return values:
       < 0    'p' is before 'q' in the alphabet.
       0      'p' and 'q' are equal.
       >0     'p' comes after 'q' in the alphabet.


*/
  int pStrnicmp(csCHAR *p,csCHAR *q,int len);
  int pStricmp(csCHAR  *p,csCHAR *q);



//Converting to uppercase/lowercase.
//This may not work for string constants because the
//string is modified at its original location.

  csCHAR *pStrupr(csCHAR *str);
  csCHAR *pStrlwr(csCHAR *str);

//Revers string.
//Example: 'large'  becomes 'egral'.
//The terminating zero remains in place.

  csCHAR *pStrrev(csCHAR *str);



/////////////////////////////////////////////////////////////////////////////

/*
   Returns the length of file 'file' in bytes.
   This even works for symbolic links and 'sparse' files.

   If an error occurs (the file cannot be found) the function returns  -1.

*/
  long pFilelength(csCHAR *file);


///////////////////////// Max & Min  /////////////////////////////////////////

/*
   Just another version of the max and min functions.

*/

inline long pMin(long x,long y) { return (x<y) ? x: y; }
inline long pMax(long x,long y) { return (x>y) ? x: y; }


//////////////////////// Bug-free isspace() /////////////////////////////

int pIsspace(int  c);


//////////////////////// Integer 2 String conversions ///////////////////

csCHAR *pItoa(int  number,csCHAR *buf,int radix);
csCHAR *pLtoa(long number,csCHAR *buf,int radix);



/////////////////////// Changing file size /////////////////////////////
// Returns  0 on success
//	   -1 on failure.

int pChsize(int handle,U32 length);


////////////////////// Splitting a file name //////////////////////////
// Splits a file name into drive,dir,name and ext.
// This function is equivalent to Borland's fnsplit();
//
// It is valid to call the function with one or more NULL pointers.
// Otherwise the pointer is supposed to point to a buffer large
// enough to hold the returned string.

// These lengths are defined in csfile.h by the following constants:
//
//    MAXPATH		path
//    MAXDRIVE		drive, includes colon  (Empty string under UNIX)
//    MAXDIR		dir, includes leading and trailing slashes
//    MAXFILE		name
//    MAXEXT		ext, includes leading dot (.)

// In case there is  more then one dot in the name (UNIX), everything after
// the *last* dot is taken as the extension.
// Names of the form:  ..example  or  .file  are considered to have no extension.
// In cases like  file..ext  it takes  ..ext  as extension.


// The return value is a bit-or of the following five flags (csfile.h):

// CS_EXTENSION    an extension
// CS_FILENAME	   a filename
// CS_DIRECTORY    a directory
// CS_DRIVE	   a drive specification
// CS_WILDCARDS    wildcards (* or ?)

// The flag is set if the corresponding component was found in the name.


int pFnsplit(const csCHAR *pathP,
		   csCHAR *drive, csCHAR *dir, csCHAR *name, csCHAR *ext);





#endif

